#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

typedef struct jarbol {
	int64_t x, y;
	int32_t id;
} Jarbol;

constexpr int32_t NOT_FOUND = -1;

static int64_t dist(const Jarbol& a, const Jarbol& b) {
	return std::abs(b.x - a.x) - std::abs(b.y - a.y);
	// ako je b veci od a za 2, a ce prvo udariti
	// u kanap i to za 2 ranije
}

static std::vector<int32_t> get_left_ids(const std::vector<Jarbol>& array) {
	std::vector<int32_t> ids(array.size(), NOT_FOUND);
	std::stack<int32_t> stack;
	const int32_t n = array.size();
	int32_t i;

	for(i = 0; i < n; ++i) {
		while (!stack.empty() && array[stack.top()].y < array[i].y) 
			stack.pop();
		if(!stack.empty())
			ids[i] = stack.top();
		stack.push(i);
	}

	return ids;
}

static std::vector<int32_t> get_right_ids(const std::vector<Jarbol>& array) {
	std::vector<int32_t> ids(array.size(), NOT_FOUND);
	std::stack<int32_t> stack;
	const int32_t n = array.size();
	int32_t i;

	for(i = n - 1; i >= 0; --i) {
		while (!stack.empty() && array[stack.top()].y < array[i].y) 
			stack.pop();
		if(!stack.empty())
			ids[i] = stack.top();
		stack.push(i);
	}

	return ids;
}


int main() noexcept {
	/*
	prvi put sam propustio da trebamo da ispisemo
	sve u istom redosledu kao sto nam je uneseno
	i da niz X nije nuzno sortiran, takode je sve
	izgledalo poprilicno ruzno jer sam mesao stilove
	*/
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	std::vector<Jarbol> jarboli;
	int64_t input;
	int32_t n, i, min_dist = 0, left_dist = 0, right_dist = 0;

	std::cin >> n;
	jarboli = std::vector<Jarbol>(n);

	for(i = 0; i < n; ++i) {
		std::cin >> jarboli[i].x;
		jarboli[i].id = i;
	}
	for(i = 0; i < n; ++i)
		std::cin >> jarboli[i].y;


	std::sort(jarboli.begin(), jarboli.end(), [](const Jarbol& a, const Jarbol& b) {
		return a.x < b.x;
	});

	// rvo bi trebao da ne kopira ceo objekat nadam se
	auto next_left = get_left_ids(jarboli);
	auto next_right = get_right_ids(jarboli);

	for(i = 0; i < n; ++i) {
		if(next_left[i] == NOT_FOUND && next_right[i] == NOT_FOUND) {
			std::cout << "-1\n";
			continue;
		}

		left_dist = (next_left[i] != NOT_FOUND) ? dist(jarboli[i], jarboli[next_left[i]]) : INT32_MAX;
		right_dist = (next_right[i] != NOT_FOUND) ? dist(jarboli[i], jarboli[next_right[i]]) : INT32_MAX;
		min_dist = std::min(left_dist, right_dist);
		std::cout << min_dist << '\n';
	}
}